﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IEncryptionContextMenuStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class EncryptionContextMenuDefaultStrategy : ICorrespondenceOS, IEncryptionContextMenuStrategy
    {
        public EncryptionContextMenuDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "EncryptionContextMenu";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced");

            registryKey.SetValue(RegName,i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced");

                return new WFRegistry(@"HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced", RegName,
                                  registryKey.GetValue(RegName,0), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class EncryptionContextMenuController
    {
        public EncryptionContextMenuController(EncryptionContextMenu encryptionContextMenu,
                                                         IEncryptionContextMenuStrategy strategy)
        {
            EncryptionContextMenu = encryptionContextMenu;
            Strategy = strategy;
        }

        public EncryptionContextMenu EncryptionContextMenu { get; set; }
        public IEncryptionContextMenuStrategy Strategy { get; set; }

        public void Read()
        {
            EncryptionContextMenu.SetEncryptionContextMenuState(Convert.ToBoolean(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(EncryptionContextMenu.GetEncryptionContextMenuState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
